/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.mccs;

import com.quantumdata.mccs.VCPCodes;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;

public class Constants {
    public static final int sliderBeginningOffset = 7;
    public static final int sliderEndingOffset = 9;
    public static final String WRITE_OPERATION = "01";
    public static final String READ_OPERATION = "02";
    public static final int NUM_CHECKBOX_SET = 2;
    public static final Font itemFont = new Font("sansserif", 1, 12);
    public static final Font setFont = new Font("Monospaced", 1, 14);
    public static final Font sliderFont = new Font("Serif", 2, 12);
    public static final int SLIDER_MIN = 0;
    public static final int SLIDER_MAX = 255;
    public static final int NUM_PRESET_CMDS = 6;
    public static final int NUM_IMAGE_CMDS = 18;
    public static final int NUM_DISPLAY_COLOR_CMDS = 12;
    public static final int NUM_GEOMETRY_CMDS = 8;
    public static final int NUM_MISC_CMDS = 23;
    public static final int NUM_AUDIO_CMDS = 7;
    public static final int NUM_DPVL_CMDS = 8;
    public static final int NUM_MANUFACTURE_CMDS = 0;
    public static final int NUM_IMAGE_SLIDERS = 36;
    public static final int NUM_GEOMETRY_SLIDERS = 25;
    public static final int NUM_AUDIO_SLIDERS = 1;
    public static final String setToolTip = "Send the setting to display device";

    public static JTextField createFieldNameText(String string) {
        JTextField jTextField = new JTextField(string);
        jTextField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jTextField.setMargin(new Insets(0, 0, 0, 0));
        jTextField.setEditable(false);
        jTextField.setFont(itemFont);
        return jTextField;
    }

    public static JTextField createSubFieldNameText(String string) {
        JTextField jTextField = new JTextField(string);
        jTextField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jTextField.setMargin(new Insets(0, 0, 0, 0));
        jTextField.setEditable(false);
        return jTextField;
    }

    public static JTextField createFieldValueText(boolean bl) {
        JTextField jTextField = new JTextField();
        jTextField.setMargin(new Insets(0, 0, 0, 0));
        jTextField.setEditable(bl);
        return jTextField;
    }

    public static JButton createSetButton(ActionListener actionListener) {
        return Constants.createButton("Set", actionListener);
    }

    public static JButton createGetButton(ActionListener actionListener) {
        return Constants.createButton("Get", actionListener);
    }

    private static JButton createButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        jButton.setToolTipText(setToolTip);
        jButton.setFont(setFont);
        return jButton;
    }

    public static JTextField createSliderText(String string) {
        JTextField jTextField = new JTextField(string);
        jTextField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jTextField.setMargin(new Insets(0, 0, 0, 0));
        jTextField.setEditable(false);
        return jTextField;
    }

    private static JSlider createSlider(int n, int n2, ChangeListener changeListener, MouseListener mouseListener, MouseMotionListener mouseMotionListener) {
        JSlider jSlider = new JSlider(n, n2);
        jSlider.addChangeListener(changeListener);
        jSlider.addMouseListener(mouseListener);
        jSlider.addMouseMotionListener(mouseMotionListener);
        jSlider.setMajorTickSpacing(10);
        jSlider.setMinorTickSpacing(1);
        jSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        jSlider.setFont(sliderFont);
        return jSlider;
    }

    public static JSlider createSlider(ChangeListener changeListener, MouseListener mouseListener, MouseMotionListener mouseMotionListener) {
        return Constants.createSlider(0, 255, changeListener, mouseListener, mouseMotionListener);
    }

    public static JSlider createSlider(int n, ChangeListener changeListener, MouseListener mouseListener, MouseMotionListener mouseMotionListener) {
        return Constants.createSlider(0, n, changeListener, mouseListener, mouseMotionListener);
    }

    public static JCheckBox createCheckbox(String string) {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        jCheckBox.setText(string);
        jCheckBox.setToolTipText(string);
        return jCheckBox;
    }

    public static JCheckBox createCheckbox(String string, ActionListener actionListener) {
        JCheckBox jCheckBox = Constants.createCheckbox(string);
        jCheckBox.addActionListener(actionListener);
        return jCheckBox;
    }

    private static JTextArea createTextArea(String string) {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setFont(itemFont);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setText(string);
        jTextArea.setOpaque(true);
        return jTextArea;
    }

    public static JTextArea createTextAreaSupported() {
        return Constants.createTextArea("Display Support Features:");
    }

    public static JTextArea createTextAreaCurrent() {
        return Constants.createTextArea("Display Current Status:");
    }

    public static String getAppdix(int n) {
        if (Integer.toHexString(n + 1).endsWith("1")) {
            return "st";
        }
        if (Integer.toHexString(n + 1).endsWith("2")) {
            return "nd";
        }
        if (Integer.toHexString(n + 1).endsWith("3")) {
            return "rd";
        }
        return "th";
    }

    public static String[] getComboStringArray(VCPCodes vCPCodes) {
        String[] stringArray = new String[vCPCodes.getNumOfSupportedDetails()];
        int n = 0;
        for (int i = 0; i < vCPCodes.getNumOfDetails(); ++i) {
            String string = vCPCodes.getDetailByIndex(i);
            if (string == null) continue;
            stringArray[n++] = string;
        }
        return stringArray;
    }
}

